#!/bin/bash
# Generate self-signed SSL certificates for nginx

echo "Generating self-signed SSL certificates..."

# Create SSL directory
mkdir -p ssl

# Generate private key
openssl genrsa -out ssl/key.pem 2048

# Generate certificate
openssl req -new -x509 -key ssl/key.pem -out ssl/cert.pem -days 365 -subj "/C=US/ST=State/L=City/O=Organization/CN=localhost"

echo "SSL certificates generated successfully!"
echo "Certificate: ssl/cert.pem"
echo "Private Key: ssl/key.pem"
echo ""
echo "To trust these certificates in your browser:"
echo "1. Import cert.pem to your browser's certificate store"
echo "2. Or access the site and accept the security warning"
