#!/bin/bash
# Rock Paper Scissors Installation Script for Unraid

echo "=== Rock Paper Scissors Game Installation ==="
echo

# Create appdata directory
APPDATA_DIR="/mnt/user/appdata/rock-paper-scissors"
echo "Creating application directory: $APPDATA_DIR"
mkdir -p "$APPDATA_DIR"

# Copy files
echo "Copying application files..."
cp -r app/* "$APPDATA_DIR/"
cp docker-compose.yml "$APPDATA_DIR/"

# Set permissions
echo "Setting file permissions..."
cd "$APPDATA_DIR"
chmod -R 755 .
chmod 775 backend/database

# Create SSL directory
echo "Creating SSL directory..."
mkdir -p ssl

echo
echo "=== Installation Complete ==="
echo
echo "Next steps:"
echo "1. Generate SSL certificates (recommended):"
echo "   cd $APPDATA_DIR && chmod +x generate-ssl.sh && ./generate-ssl.sh"
echo
echo "2. Deploy containers using either:"
echo "   a) Docker Compose: cd $APPDATA_DIR && docker-compose up -d"
echo "   b) Individual containers through Unraid web UI"
echo
echo "3. Access the game at:"
echo "   HTTPS: https://YOUR_UNRAID_IP"
echo "   HTTP: http://YOUR_UNRAID_IP (redirects to HTTPS)"
echo
